/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.lib.web.okhttp;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import net.creeperhost.minetogether.lib.web.EngineRequest;
import net.creeperhost.minetogether.lib.web.EngineResponse;
import net.creeperhost.minetogether.lib.web.WebEngine;
import net.creeperhost.minetogether.lib.web.okhttp.OkHttpEngineRequest;
import net.creeperhost.minetogether.lib.web.okhttp.OkHttpEngineResponse;
import net.creeperhost.minetogether.lib.web.okhttp.SimpleCookieJar;
import okhttp3.ConnectionPool;
import okhttp3.CookieJar;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public abstract class OkHttpWebEngine
implements WebEngine {
    public static OkHttpWebEngine create() {
        return OkHttpWebEngine.create(new OkHttpClient.Builder().connectTimeout(5L, TimeUnit.MINUTES).readTimeout(5L, TimeUnit.MINUTES).connectionPool(new ConnectionPool()).cookieJar((CookieJar)new SimpleCookieJar()).build());
    }

    public static OkHttpWebEngine create(final OkHttpClient client) {
        return new OkHttpWebEngine(){

            @Override
            protected OkHttpClient getClient() {
                return client;
            }
        };
    }

    protected abstract OkHttpClient getClient();

    @Override
    public EngineRequest newRequest() {
        return new OkHttpEngineRequest();
    }

    @Override
    public EngineResponse execute(EngineRequest r) throws IOException {
        if (!(r instanceof OkHttpEngineRequest)) {
            throw new IllegalArgumentException("Only supports executing OkHttpEngineRequest.");
        }
        Request request = ((OkHttpEngineRequest)r).build();
        Response response = this.getClient().newCall(request).execute();
        return new OkHttpEngineResponse(response);
    }
}

